#!/bin/bash

# checkmedia.sh
#
# Usage: checkmedia.sh <device file> <temp file> <log file>
#
# Author: C. Schuck

DEVICEFILE=$1
TEMPFILE=$2
MEDIA=$3
LOGFILE=$4

echo "-> checkmedia.sh" >> $LOGFILE
echo "Checking if the media is present in the device at $DEVICEFILE for `date`" >> $LOGFILE

actzTrace "XMDA   T: -> checkmedia.sh"
actzTrace "XMDA   F: checkmedia.sh: Checking if the media is present in the device at $DEVICEFILE for `date`"                    
                     
# Check to see if the temp file exists
if [ -e $TEMPFILE ]; then
    # If the temp file already exists, delete it now
    rm -vf $TEMPFILE >> $LOGFILE 2>&1
fi

dd if=$DEVICEFILE bs=1 skip=32808 count=1 > $TEMPFILE 2>&1

cat $TEMPFILE >> $LOGFILE

# Determine what drive is to be used to check for the presence of the media
case "$MEDIA" in
    1)
        # Check if the media is present in a diskette drive
	echo "Checking a diskette drive for the presence of the media." >> $LOGFILE
	actzTrace "XMDA   F: checkmedia.sh: Checking a diskette drive for the presence of the media."
        
        if grep -q -i 'No such device or address' $TEMPFILE; then
            echo "No media is present in the diskette drive." >> $LOGFILE
	    actzTrace "XMDA   F: checkmedia.sh: No media is present in the diskette drive."
            exit 1
        else
            actzTrace "XMDA   F: checkmedia.sh: Media is present in the diskette drive."
	    echo "Media is present in the diskette drive." >> $LOGFILE
	fi
    ;;
    2)
        # Check if the media is present in a CD-ROM/DVD-RAM drive
	echo "Checking a CD-ROM/DVD-RAM drive for the presence of the media." >> $LOGFILE
        actzTrace "XMDA   F: checkmedia.sh: Checking a CD-ROM/DVD-RAM drive for the presence of the media." 
	
        if grep -q -i 'No medium found' $TEMPFILE; then
	    echo "No media is present in the CD-ROM/DVD-RAM drive." >> $LOGFILE
            actzTrace "XMDA   F: checkmedia.sh: No media is present in the CD-ROM/DVD-RAM drive." 
	    exit 1
	else
	    echo "Media is present in the CD-ROM/DVD-RAM drive." >> $LOGFILE
            actzTrace "XMDA   F: checkmedia.sh: Media is present in the CD-ROM/DVD-RAM drive."
	fi
    ;;
esac

actzTrace "XMDA   T: <- checkmedia.sh"
echo "<- checkmedia.sh" >> $LOGFILE
echo "" >> $LOGFILE

exit 0


